#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1  clrWhite
#property indicator_color2  clrWhite
#property strict

extern ENUM_TIMEFRAMES TimeFrame       = PERIOD_CURRENT;   // Time frame
input int              Fast_MA_Period  = 12;               // Fast ma period
input int              Slow_MA_Period  = 26;               // Slow ma period
input int              Signal_period   = 9;                // Signal period
input double           ArrowGapUp      = 0.5;              // Gap for up arrow        
input double           ArrowGapDn      = 0.5;              // Gap for down arrow
input bool             ArrowOnFirst    = true;             // Arrow on first mtf bar
input bool             alertsOn        = false;            // Alerts on true/false?
input bool             alertsOnCurrent = true;             // Alerts on current open bar true/false?
input bool             alertsMessage   = true;             // Alerts pop-up message true/false?
input bool             alertsSound     = false;            // Alerts sound true/false?
input bool             alertsPushNotif = false;            // Alerts push notification true/false?
input bool             alertsEmail     = false;            // Alerts email true/false?
input string           soundFile       = "alert2.wav";     // Alerts sound file

double b2[],b3[],Buffer1[],Buffer2[],trend[],count[];
string indicatorFileName;
#define _mtfCall(_buff,_y) iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,Fast_MA_Period,Slow_MA_Period,Signal_period,ArrowGapUp,ArrowGapUp,ArrowOnFirst,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsPushNotif,alertsEmail,soundFile,_buff,_y)
      
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
{
   IndicatorBuffers(6);
   SetIndexBuffer(0,b2); SetIndexStyle(0,DRAW_ARROW,STYLE_SOLID,1); SetIndexArrow(0,242); 
   SetIndexBuffer(1,b3); SetIndexStyle(1,DRAW_ARROW,STYLE_SOLID,1); SetIndexArrow(1,241);   
   SetIndexBuffer(2,Buffer1);
   SetIndexBuffer(3,Buffer2);
   SetIndexBuffer(4,trend);
   SetIndexBuffer(5,count);
   
   indicatorFileName = WindowExpertName();
   TimeFrame         = fmax(TimeFrame,_Period);
   
   IndicatorShortName(timeFrameToString(TimeFrame)+" Sma CrossOver");
return(INIT_SUCCEEDED);
}
void OnDeinit(const int reason) { }


int OnCalculate(const int rates_total,const int prev_calculated,const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
    
   int i,counted_bars=prev_calculated;
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit = fmin(rates_total-prev_calculated,rates_total-1); count[0] = limit;
   
   //
   //
   //
   //
   //
   
   if (TimeFrame == _Period)
   {
     for(i=limit; i>=0; i--) Buffer1[i] = iMA(NULL,0,Fast_MA_Period,0,MODE_SMA,PRICE_MEDIAN,i)-iMA(NULL,0,Slow_MA_Period,0,MODE_SMA,PRICE_MEDIAN,i);
     for(i=limit; i>=0; i--)
     {
        Buffer2[i] = iMAOnArray(Buffer1,rates_total,Signal_period,0,MODE_LWMA,i);
        trend[i]   = (i<rates_total-1) ? (Buffer2[i]>Buffer1[i]) ? 1 : (Buffer2[i]<Buffer1[i]) ? -1 : trend[i+1] : 0;
        b2[i] = EMPTY_VALUE;
        b3[i] = EMPTY_VALUE;
        if (i<rates_total-1 && trend[i]!=trend[i+1])
        {
           if (trend[i] ==  1) b3[i] = Low[i] -iATR(NULL,0,15,i)*ArrowGapUp;
           if (trend[i] == -1) b2[i] = High[i]+iATR(NULL,0,15,i)*ArrowGapDn;
        }
     }   
       
      //
      //
      //
      //
      //
        
      if (alertsOn)
      {
         int whichBar = 1; if (alertsOnCurrent) whichBar = 0; 
         if (trend[whichBar] != trend[whichBar+1])
         {
            if (trend[whichBar] == 1) doAlert(" up");
            if (trend[whichBar] ==-1) doAlert(" down");       
         }         
       }              
   return(rates_total);
   }
   
   //
   //
   //
   //
   //

   limit = (int)fmax(limit,fmin(rates_total-1,_mtfCall(5,0)*TimeFrame/_Period));
   for (i=limit; i>=0; i--)
   {
      int y = iBarShift(NULL,TimeFrame,Time[i]);
      int x = y;
      if (ArrowOnFirst)
            {  if (i<rates_total-1) x = iBarShift(NULL,TimeFrame,Time[i+1]);               }
      else  {  if (i>0)             x = iBarShift(NULL,TimeFrame,Time[i-1]); else x = -1;  }
          b2[i] = (x!=y) ? _mtfCall(0,y) : EMPTY_VALUE;
          b3[i] = (x!=y) ? _mtfCall(1,y) : EMPTY_VALUE;
   }
return(rates_total);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message = timeFrameToString(_Period)+" "+_Symbol+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" SMA CrossOver "+doWhat;
             if (alertsMessage)     Alert(message);
             if (alertsPushNotif )  SendNotification(message);
             if (alertsEmail)       SendMail(_Symbol+" SMA CrossOver ",message);
             if (alertsSound)       PlaySound(soundFile);
      }
}

//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}





